/* BEGIN JPSS HEADER */
/*****************************************************************************
*
* Peraton, Inc.  All rights reserved.
*
* GOVERNMENT RIGHTS:
* Per contract 1332KP23CNEEJ0001, CAR 1352.227-70 applies giving full
* copyrights to data, including reports and other copyrighted materials
* to the United States Government.
*
* THIRD PARTY RIGHTS:
* Note: Third party entities may own copyrights in this work.
*
* EXPORT CONTROL:
* Unless otherwise specified beneath this header, this item does not contain
* Technology or Technical Data controlled under either the U.S. International
* Traffic in Arms Regulations or the U.S. Export Administration Regulations.
*
* CLASSIFICATION: B
* Refer to Software Standards and Practices Manual (SSPM) for coding and
* documentation standards.
*
*****************************************************************************/
/* END JPSS HEADER */

/*****************************************************************************
*
*  NAME: EngineeringCalibrationRecord.h
*
*  DESCRIPTION:   See description preceeding declaration below
*
*****************************************************************************/

/***********************************************************************
*  HISTORY:
*
* DATE        PR#      AUTHOR            Build    DESCRIPTION
* ---------   ---      ------            -----    -----------
* 25Apr2005            Bryan Henderson     1.3    Initial Version
*                      Dan Elliott
*                      Tim Hahn
* 02Aug2006  011858    Dan Elliott         1.4    Modified ITT header with
*                                                 permission from Steven G.
*                                                 Minnie from ITT Space
*                                                 Systems, LLC
* 25Oct2008            L. Wang           ALG01342 Implem with ITT update 2.14
* 20Jan2009   19301    K. Boswell        1.5x1    ISTN_CRIS_SDR_UNIX_NGST_2.1
*                                                 drop implementation
*                                                 per TM NP-EMD.2008.510.0055
* 03Feb2010   21718    K. Boswell        SensChar ISTN_CRIS_SDR_UNIX_NGST_2.2
*                                                 drop implementation
*                                                 per TM NP-EMD.2009.510.0046
* 12Nov2012   31266    S. Wilderdyke     Blk1.5   Modified serialize() to use
*                                                 cris_(i/o)archive instead of
*                                                 BOOST (i/o)archive
* 19Nov2012   32693    T. Gardner         Mx7     Add trim table values class
* 06HUN2013   34187-88 T. Gardner         Mx8.0   LaserWavelength is updated
*                                                 only when CMO is updated
*                                                 and saved
* 25JUN2014            Y. Chen/Y.Han      Mx8.5   Add variable calibrationOrder
*                                                 and overload refreshData
* 14OCT2014  042555    SEClark         Blk2.0.0.4 CrIS SSPM Compliance.
* 03JAN2015   41268    J. Eberle         Blk2.0   Header Changes
* 11MAY2015   48586    T. Gardner        Blk2.0   Integrate TR/FR updates into
*                                                 block 2.0
***********************************************************************/

/*******************************************************************************
* This document contains information proprietary and confidential to ITT Space
* Systems, LLC ("ITT"), or a third party for whom ITT may have a legal
* obligation to protect such information from unauthorized disclosure, use or
* duplication. Any disclosure, use, duplication or diversion contrary
* to U.S. Law of this document or of any of the information contained herein
* for other than the
* specific purpose for which it was disclosed is expressly prohibited,
* except as ITT has otherwise
* agreed in writing or as the U.S. Government has authorized. All copies of
* this document are the
* sole property of ITT and will be returned promptly upon request
******************************************************************************/

#ifndef _INC_ENGINEERINGCALIBRATIONRECORD_3F8A9B82029D_INCLUDED
#define _INC_ENGINEERINGCALIBRATIONRECORD_3F8A9B82029D_INCLUDED

#include <CalibrationRecord.h>
#include <EngCalRec_ICTEmissivityParameters.h>
#include <EngCalRec_ILSCurveFitParameters.h>
#include <EngCalRec_ILSFOVParameters.h>
#include <EngCalRec_ICTEnvironmentalModel.h>
#include <EngCalRec_ScienceTelemetryConversionCoefficients.h>
#include <EngCalRec_PolarizationCalibrationWavenumbers.h>
#include <EngCalRec_NeonCalInfo.h>
#include <EngCalRec_LaserMetrologyInfo.h>
#include <EngCalRec_ScienceTelemetryLimits.h>
#include <EngCalRec_PitchRollYawInfo.h>
#include <EngCalRec_LinearityErrorParameters.h>
#include <EngCalRec_ExtractionRecord.h>
#include <BoostLibrary.h>
#include <CCSDSFormat.h>
#include <CcsdsSecondaryHeader.h>
#include <TelemetryProcessor.h>
#include <EventLogEngine.h>
#include <numeric>
#include <Octets.h>
#include <CrIS_InstrumentCharacteristics.h>
#include <TelemetryStateConverter.h>
#include <limits>
#include <ProSdrCrisGbl.h>
#include <CrISDataStream.h>

class EngineeringCalibrationRecord :
public CalibrationRecord
{
 public:
   EngineeringCalibrationRecord();
   virtual ~EngineeringCalibrationRecord();
   virtual bool refreshData(UInt16 theApid)
               {(void)theApid; return false;}
   bool refreshData(UInt16 theApid, CCSDSFormat* theTelemetryFormat);
   bool refreshData(UInt16 theApid, CCSDSFormat* theTelemetryFormat,
      CalibrationOrder theOrder);
   inline EngCalRec_ICTEmissivityParameters&
            getEngCalRec_ICTEmissivityParameters()
              {return theEngCalRec_ICTEmissivityParameters;}
   inline const EngCalRec_ILSCurveFitParameters&
            getEngCalRec_ILSCurveFitParameters() const
              {return theEngCalRec_ILSCurveFitParameters;}
   inline EngCalRec_ILSFOVParameters&
            getEngCalRec_ILSFOVParameters()
              {return theEngCalRec_ILSFOVParameters;}
   inline const EngCalRec_ICTEnvironmentalModel&
            getEngCalRec_ICTEnvironmentalModel() const
              {return theEngCalRec_ICTEnvironmentalModel;}
   inline const EngCalRec_ScienceTelemetryConversionCoefficients&
            getEngCalRec_ScienceTelemetryConversionCoefficients() const
              {return theEngCalRec_ScienceTelemetryConversionCoefficients;}
   inline const EngCalRec_PolarizationCalibrationWavenumbers&
            getEngCalRec_PolarizationCalibrationWavenumbers() const
              {return theEngCalRec_PolarizationCalibrationWavenumbers;}
   inline const EngCalRec_ScienceTelemetryLimits&
            getEngCalRec_ScienceTelemetryLimits() const
              {return theEngCalRec_ScienceTelemetryLimits;}
   inline const EngCalRec_NeonCalInfo&
            getEngCalRec_NeonCalInfo() const
              {return theEngCalRec_NeonCalInfo;}
   inline const EngCalRec_LaserMetrologyInfo&
            getEngCalRec_LaserMetrologyInfo() const
              {return theEngCalRec_LaserMetrologyInfo;}
   inline const EngCalRec_LinearityErrorParameters&
            getEngCalRec_LinearityErrorParameters() const
              {return theEngCalRec_LinearityErrorParameters;}
   inline const EngCalRec_ExtractionRecord&
            getEngCalRec_ExtractionRecord() const
              {return theEngCalRec_ExtractionRecord;}
   inline void
            setComputedWavelengthRejectionThreshold(
                  UInt32 theRejectionThreshold)
              {computedWavelengthRejectionThreshold = theRejectionThreshold;}
   inline const Float64&
            getAverageMetrologyWavelength() const
              {return averageMetrologyWavelength;}
   inline void setAverageMetrologyWavelength(Float64 theAverageMetrologyWavelength)
              {averageMetrologyWavelength = theAverageMetrologyWavelength;}
   inline const Float64&
            getRejectedWavelengthsRatio() const
              {return rejectedWavelengthsRatio;}
   inline void
            setEngLaserDiodeTemperature(Float64 theEngLaserDiodeTemperature)
              {engLaserDiodeTemperature = theEngLaserDiodeTemperature;}
   inline const Float64&
            getEngLaserDiodeTemperature() const
              {return engLaserDiodeTemperature;}
   inline void
            setEngLaserDiodeCurrent(Float64 theEngLaserDiodeCurrent)
              {engLaserDiodeCurrent = theEngLaserDiodeCurrent;}
   inline const Float64&
            getEngLaserDiodeCurrent() const
              {return engLaserDiodeCurrent;}
   virtual std::string toString() const
              {return "no";}

   // Serialize calibration matrix to archive container
   virtual void serialize(cris_oarchive& ar);
   virtual void serialize(cris_iarchive &ar);

   inline void setLaserDiodeWavelengthOrigin(
                       LaserWavelengthSource theLaserDiodeWavelengthOrigin)
              {laserDiodeWavelengthOrigin = theLaserDiodeWavelengthOrigin;}
   inline void setEngCalBaffleTempOffset(BOOST::vector<Float32> & newProfile)
        { theEngCalRec_ICTEnvironmentalModel.setBaffleTempOffset(newProfile); }
   inline void setEngCalLaserWavelength()
   {
      theEngCalRec_LaserMetrologyInfo.setLaserWavelength(
                                      getAverageMetrologyWavelength());
   }
   void calculateMetrologyWavelength();
   inline void setIlsOriginSource(IlsOriginSource curSource)
              {ilsOrigin = curSource;}
   inline void setIlsParameters(ILS_Parameters theParams)
              {ilsParams = theParams;}
   inline const EngCalRec_PitchRollYawInfo& getEngCalRec_PitchRollYawInfo()
          const {return theEngCalRec_PitchRollYawInfo;}
   inline BOOST::vector<Float64>& getLOSInSSMF(SceneElement theFov)
      {
         return losInSSMF[theFov];
      }
   inline BOOST::vector<Float64>& getNormalRMF() {return normalRMF;}
   inline BOOST::matrix<Float64>& getSBFToSSMF() {return sbfToSSMFMatrix;}
   inline void resetPolarizationValuesChanged()
              {theEngCalRec_PolarizationCalibrationWavenumbers.
                                        resetPolarizationValuesChanged();}
   inline Int64 getIETTime(){return ietTime;}
   inline void setIETTime(Int64 a){ietTime = a;}
   BOOST::matrix<Float64> rotationMatrixY(Float64 thePitch);
   BOOST::matrix<Float64> rotationMatrixX(Float64 theRoll);
   BOOST::matrix<Float64> rotationMatrixZ(Float64 theYaw);
   inline virtual void setInstrumentCharacteristics(
           const CrIS_InstrumentCharacteristics& newValues)
      {
          // Update the parent class.
          CalibrationRecord::setInstrumentCharacteristics(newValues);
          theEngCalRec_ICTEmissivityParameters.setInstrumentCharacteristics(
                  newValues);
          theEngCalRec_LinearityErrorParameters.setInstrumentCharacteristics(
                  newValues);
      }
   inline void setLastCheckSumValue(const Int32 newValue)
   {
       lastCheckSumValue = newValue;
   }
   inline Int32 getLastCheckSumValue() const
   {
       return lastCheckSumValue;
   }

 private:
   Int64 ietTime;
   UInt32   computedWavelengthRejectionThreshold;
   Float64 rejectedWavelengthsRatio;
   Float64 averageMetrologyWavelength;
   Float64 engLaserDiodeTemperature;
   Float64 engLaserDiodeCurrent;
   LaserWavelengthSource laserDiodeWavelengthOrigin;
   IlsOriginSource ilsOrigin;
   ILS_Parameters ilsParams;
   EngCalRec_ICTEmissivityParameters theEngCalRec_ICTEmissivityParameters;
   EngCalRec_ILSCurveFitParameters theEngCalRec_ILSCurveFitParameters;
   EngCalRec_ILSFOVParameters theEngCalRec_ILSFOVParameters;
   EngCalRec_ICTEnvironmentalModel theEngCalRec_ICTEnvironmentalModel;
   EngCalRec_ScienceTelemetryConversionCoefficients
      theEngCalRec_ScienceTelemetryConversionCoefficients;
   EngCalRec_PolarizationCalibrationWavenumbers
      theEngCalRec_PolarizationCalibrationWavenumbers;
   EngCalRec_LaserMetrologyInfo theEngCalRec_LaserMetrologyInfo;
   EngCalRec_NeonCalInfo theEngCalRec_NeonCalInfo;
   EngCalRec_ScienceTelemetryLimits theEngCalRec_ScienceTelemetryLimits;
   EngCalRec_PitchRollYawInfo theEngCalRec_PitchRollYawInfo;
   EngCalRec_LinearityErrorParameters theEngCalRec_LinearityErrorParameters;
   EngCalRec_ExtractionRecord theEngCalRec_ExtractionRecord;
   void initializeGeometricCalibration();
   BOOST::vector<Float64> losInSSMF[MAX_FOV];
   BOOST::vector<Float64> normalRMF;
   BOOST::matrix<Float64> sbfToSSMFMatrix;
   Int32 lastCheckSumValue;
   Int32 packetVersionNumber;
};
#endif /* _INC_ENGINEERINGCALIBRATIONRECORD_3F8A9B82029D_INCLUDED */
